/*-----------------------------------------------------------------------------
	OMR API (omrapi.dll) Header

	Copyright 2002-2010 SEKONIC CORPORATION

	Version history
	---------------------------------------------------------------------------
		date		version		notes
	---------------------------------------------------------------------------
		2010.10.08	4.2.0		SkCommIo.dll is used.

		2010.03.30	4.1.0		Minor fix.

		2009.05.13	4.0.0		add define MachineName

		2007.06.23	3.0.0		add Status code
									SR_ERROR_STATUS_A8
									SR_ERROR_STATUS_S3
									SR_ERROR_STATUS_S4

		2004.05.18	2.5.0		add Printer Enabled function
		2003.10.15	2.4.0		modified Error Message
		2003.08.05	2.3.0		add Barcode function
								add Sleep Mode function
		2003.01.31	2.2.0		add Printer function
		2002.12.06	2.1.0		release

		2002.08.20	1.0.0		first release

-----------------------------------------------------------------------------*/

#ifndef	__OMR_API_H_
#define	__OMR_API_H_

#include <windows.h>


/*-----------------------------------------------------------------------------
System Fixed Number
-----------------------------------------------------------------------------*/
typedef unsigned int OMR_STATUS;

/*-Status(OMR_STATUS)-------------------*/
enum{
	SR_SUCCESS							= 0,
	SR_UNSUCCESSFUL						,
	SR_DISCONNECTED						,
	SR_WRONG_PARAMETER					,
	SR_MEMORY_ERROR						,
	SR_TIMEOUT							,
	SR_RECEIVE_NAK						,
	SR_WRONG_RESPONSE					,
	/*
	Status Error Information
	  0xXXXXXXXX
		||||
		||++------- :Page
		||
		|+------ 0x0	:Main
		|        0x1	:Sensor unit
		|        0x2	:(reserved)
		|        0x3	:Barcode reader unit
		|        0x4	:Printer unit
		|        0x5	:Stacker unit
		|        0xf	:other
		|
		+---- 0x0	:impossible to recovery(Hard error)
			  0x1	:Communication error
		      0x2	:Cover open error
		      0x3	:Jam error
		      0x4	:Warning
	*/
	SR_ERROR_STATUS_A1					= 0x00010000,
	SR_ERROR_STATUS_A2					,
	SR_ERROR_STATUS_A3					,
	SR_ERROR_STATUS_A4					,
	SR_ERROR_STATUS_A5					,
	SR_ERROR_STATUS_A6					,
	SR_ERROR_STATUS_A7					,					/* Ver2.3.0	*/
	SR_ERROR_STATUS_A8					,					/* Ver3.0.0	*/

	SR_ERROR_STATUS_B1F					= 0x01020000,
	SR_ERROR_STATUS_B2F					,
	SR_ERROR_STATUS_B3F					,
	SR_ERROR_STATUS_B4F					,
	SR_ERROR_STATUS_B5F					,
	SR_ERROR_STATUS_B6F					,
	SR_ERROR_STATUS_B7F					,					/* Ver2.3.0	*/

	SR_ERROR_STATUS_B1B					= 0x02020000,
	SR_ERROR_STATUS_B2B					,
	SR_ERROR_STATUS_B3B					,
	SR_ERROR_STATUS_B4B					,
	SR_ERROR_STATUS_B5B					,
	SR_ERROR_STATUS_B6B					,
	SR_ERROR_STATUS_B7B					,					/* Ver2.3.0	*/

	SR_ERROR_STATUS_C1					= 0x03030000,
	SR_ERROR_STATUS_C2					,
	SR_ERROR_STATUS_C3					,
	SR_ERROR_STATUS_C4					,
	SR_ERROR_STATUS_C5					,
	SR_ERROR_STATUS_C6					,
	SR_ERROR_STATUS_C7					,					/* Ver2.3.0	*/

	SR_ERROR_STATUS_D1					= 0x04040000,
	SR_ERROR_STATUS_D2					,
	SR_ERROR_STATUS_D3					,
	SR_ERROR_STATUS_D4					,
	SR_ERROR_STATUS_D5					,
	SR_ERROR_STATUS_D6					,					/* Ver2.3.0	*/

	SR_ERROR_STATUS_E1					= 0x05050000,
	SR_ERROR_STATUS_E2					,
	SR_ERROR_STATUS_E3					,
	SR_ERROR_STATUS_E4					,
	SR_ERROR_STATUS_E5					,
	SR_ERROR_STATUS_E6					,					/* Ver2.3.0	*/

	SR_ERROR_STATUS_F1					= 0x1f060000,
	SR_ERROR_STATUS_F2					,
	SR_ERROR_STATUS_F3					,
	SR_ERROR_STATUS_F4					,
	SR_ERROR_STATUS_F5					,
	SR_ERROR_STATUS_F6					,
	SR_ERROR_STATUS_F7					,

	SR_ERROR_STATUS_G1					= 0x20070000,
	SR_ERROR_STATUS_G2					= 0x25070001,
//	SR_ERROR_STATUS_G3					= 0x25070002,		/* Ver2.3.0	*/

	SR_ERROR_STATUS_H1					= 0x30080000,
	SR_ERROR_STATUS_H2					,
	SR_ERROR_STATUS_H3					,
	SR_ERROR_STATUS_H4					,

	SR_ERROR_STATUS_I1					= 0x35090000,
	SR_ERROR_STATUS_I2					,
	SR_ERROR_STATUS_I3					,
//	SR_ERROR_STATUS_I4					,					/* Ver2.3.0	*/

	SR_ERROR_STATUS_P1					= 0x42100000,
	SR_ERROR_STATUS_P2					= 0x43100001,
	SR_ERROR_STATUS_P3					= 0x44100002,
	SR_ERROR_STATUS_P4					= 0x45100003,

	SR_ERROR_STATUS_Q1					= 0x40110000,
	SR_ERROR_STATUS_Q2					,
	SR_ERROR_STATUS_Q3					,
	SR_ERROR_STATUS_Q4					,

	SR_ERROR_STATUS_R1					= 0x40120000,
	SR_ERROR_STATUS_R2					,
	SR_ERROR_STATUS_R3					,

	SR_ERROR_STATUS_R4M					= 0x40120003,
	SR_ERROR_STATUS_R4F					= 0x41120003,
	SR_ERROR_STATUS_R4B					= 0x42120003,

	SR_ERROR_STATUS_R5M					= 0x40120004,
	SR_ERROR_STATUS_R5F					= 0x41120004,
	SR_ERROR_STATUS_R5B					= 0x42120004,

	SR_ERROR_STATUS_S1F					= 0x41130000,
	SR_ERROR_STATUS_S2F					,
	SR_ERROR_STATUS_S1B					= 0x42130002,
	SR_ERROR_STATUS_S2B					,
	SR_ERROR_STATUS_S3					= 0x40130002,		/* Ver3.0.0	*/
	SR_ERROR_STATUS_S4					= 0x40130003,		/* Ver3.0.0	*/

	SR_ERROR_STATUS_T1					= 0x40140000,
	SR_ERROR_STATUS_T2					,
	SR_ERROR_STATUS_T3					,

	SR_ERROR_STATUS_T4					= 0x45140003,
	SR_ERROR_STATUS_T5					,
	SR_ERROR_STATUS_T6					,

	SR_ERROR_TERM						= 0xffffffff
};


/*-Global Parameter---------------------*/
#define	SR_INITIAL						0x80000000
#define	SR_DISABLE						0
#define	SR_ENABLE						1

#define	SR_FUNCTION_FAIL				0xffffffff


/*-Language(iLanguageFlag)--------------*/
enum{
	SR_STRING_NORMAL					= 0,
	SR_STRING_ENGLISH					,
	SR_STRING_JAPANESE					,
};


/*-Page(iPage)--------------------------*/
enum{
	SR_PAGE_FRONT						= 0,
	SR_PAGE_BACK						,
};
#define SR_PAGE_MAX						2


/*-Col Row------------------------------*/
#define SR_COL_MAX						48
#define SR_ROW_MAX						155


/*-Reading Method(iControlType)---------*/
enum{
	SR_READ_FRONT_EDGE					= 1,		/*	Front Edge control type	*/
	SR_READ_REAR_EDGE					,			/*	Rear Edge control type	*/
	SR_READ_DIRECT						,			/*	Direct type	*/
	SR_READ_FACOM						,			/*	FACOM type	*/
	SR_READ_BETWEEN_MARK_NO_SPACE		,			/*	Between mark and mark without front edge space	*/
	SR_READ_BETWEEN_MARK				,			/*	Between mark and mark	*/
	SR_READ_INITIAL						=SR_INITIAL,/*	Initialize control type	*/
};


/*-Feed Mode(iMode)---------------------*/
#define	SR_MODE_AUTO					0
#define	SR_MODE_MANUAL					1


/*-Sheet thickness(iThickness)----------*/
enum{
	SR_THICKNESS_AUTO_DETECT			= 0,		/*	Auto			*/
	SR_THICKNESS_64_GPM2				= 1,		/*	64g/m2  (55kg)	*/
	SR_THICKNESS_84_GPM2				,			/*	84g/m2  (72kg)	*/
	SR_THICKNESS_105_GPM2				,			/*	105g/m2 (90kg)	*/
	SR_THICKNESS_128_GPM2				,			/*	128g/m2 (110kg)	*/
	SR_THICKNESS_157_GPM2				,			/*	157g/m2 (135kg)	*/
	SR_THICKNESS_INITIAL				=SR_INITIAL,/*	initailze		*/

	SR_THICKNESS_80_MICRON				= 1,		/*	0.08mm (55kg)	*/
	SR_THICKNESS_110_MICRON				,			/*	0.11mm (72kg)	*/
	SR_THICKNESS_130_MICRON				,			/*	0.13mm (90kg)	*/
	SR_THICKNESS_160_MICRON				,			/*	0.16mm (110kg)	*/
	SR_THICKNESS_190_MICRON				,			/*	0.19mm (135kg)	*/

	SR_THICKNESS_55_KG 					= 1,		/*	64g/m2  (55kg)	*/
	SR_THICKNESS_72_KG					,			/*	84g/m2  (72kg)	*/
	SR_THICKNESS_90_KG					,			/*	105g/m2 (90kg)	*/
	SR_THICKNESS_110_KG					,			/*	128g/m2 (110kg)	*/
	SR_THICKNESS_135_KG					,			/*	157g/m2 (135kg)	*/
};


/*-WarningError(dwConfigData)-----------*/
#define SR_WARN_MARK_SKEW				0x00200000
#define SR_WARN_LEFT_SKEW				0x00100000
#define SR_WARN_DF_ERROR				0x00080000
#define SR_WARN_TM_ERROR				0x00040000
#define SR_WARN_HOPPER_EMPTY			0x00020000
#define SR_WARN_AUTO_REJECT				0x00010000

#define SR_WARN_NONE					0x00000000
#define SR_WARN_ALL						0x003f0000
#define SR_WARN_INITIAL					0x10000000


/*-Buzzer Volume(iVolume)---------------*/
#define	SR_BUZZER_DISABLE				0			/* Buzzer Off			*/
#define	SR_BUZZER_MIN					1			/* Buzzer Volume Min.	*/
#define	SR_BUZZER_MAX					5			/* Buzzer Volume Max.	*/
#define	SR_BUZZER_INITIAL				SR_INITIAL


/*-Buzzer Tone(iTone)-------------------*/
enum{
	SR_BUZZER_TONE_A					= 1,
	SR_BUZZER_TONE_B					,
	SR_BUZZER_TONE_C					,
};


/*-ID(pID)------------------------------*/
#define SR_ID_LENGTH_MAX				20


/*-SleepTime(iSleepTime)----------------*/
#define SR_SLEEPTIME_INITIAL			SR_INITIAL
#define SR_SLEEPTIME_DISABLE			0
#define SR_SLEEPTIME_MIN				1
#define SR_SLEEPTIME_MAX				60
#define SR_STANDBYTIME_DISABLE			0
#define SR_STANDBYTIME_MIN				1
#define SR_STANDBYTIME_MAX				60


/*-Hopper(iDirection)-------------------*/
#define SR_HOPPER_DOWN					0
#define SR_HOPPER_UP					1


/*-Eject (iDirection)-------------------*/
enum{
	SR_EJECT_MAIN						= 1,
	SR_EJECT_SELECT						,
	SR_EJECT_MAIN_ON_NEXT				,
	SR_EJECT_SELECT_ON_NEXT				,
};


/*-Mark Type(OMR_MARK.type)-------------*/
#define	SR_MARK_TYPE_16					16
#define	SR_MARK_TYPE_256				256


/*-SensorInfo---------------------------*/
#define	SR_SENSOR_OUTPS					0x20000000
#define	SR_SENSOR_RDPS					0x10000000
#define	SR_SENSOR_INPS					0x08000000
#define	SR_SENSOR_PS0					0x04000000
#define	SR_SENSOR_UPPS					0x02000000
#define	SR_SENSOR_DWPS					0x01000000
#define	SR_SENSOR_SKS					0x00100000
#define	SR_SENSOR_MAIN_CVR				0x00010000

/*#define	SR_SENSOR_SPS					0x00000800*/	/* Ver2.3.0	*/
/*#define	SR_SENSOR_MPS					0x00000400*/	/* Ver2.3.0	*/
/*#define	SR_SENSOR_P2PS					0x00000200*/	/* Ver2.3.0	*/
/*#define	SR_SENSOR_STPS					0x00000100*/	/* Ver2.3.0	*/
#define	SR_SENSOR_SPS					0x00000400			/* Ver2.3.0	*/
#define	SR_SENSOR_MPS					0x00000200			/* Ver2.3.0	*/
#define	SR_SENSOR_P2PS					0x00000100			/* Ver2.3.0	*/
/*#define	SR_SENSOR_STK_CVR2				0x00000002*/	/* Ver2.3.0	*/
#define	SR_SENSOR_STK_CVR1				0x00000001
#define	SR_SENSOR_STK_CVR				0x00000001			/* Ver2.3.0	*/


/*-DeviceInfo---------------------------*/
#define	SR_DEVICE_UNIT_STACKER_MASK		0xf0000000			/* Ver2.3.0	*/
#define	SR_DEVICE_UNIT_STACKER			0x10000000
#define	SR_DEVICE_UNIT_STACKER_ERR		0x80000000
#define	SR_DEVICE_UNIT_PRINTER_MASK		0x0f000000			/* Ver2.3.0	*/
#define	SR_DEVICE_UNIT_PRINTER			0x01000000
#define	SR_DEVICE_UNIT_PRINTER_ERR		0x08000000
#define	SR_DEVICE_UNIT_BARCODE_MASK		0x00f00000			/* Ver2.3.0	*/
#define	SR_DEVICE_UNIT_BARCODE_V		0x00100000
#define	SR_DEVICE_UNIT_BARCODE_H		0x00200000
#define	SR_DEVICE_UNIT_BARCODE_ERR		0x00800000
#define	SR_DEVICE_UNIT_BACK_MASK		0x000f0000			/* Ver2.3.0	*/
#define	SR_DEVICE_UNIT_BACK				0x00010000
#define	SR_DEVICE_SENSOR_TYPE_MASK		0x000000f0			/* Ver2.3.0	*/
#define	SR_DEVICE_SENSOR_TYPE_ERR		0x00000080			/* Ver2.3.0	*/
#define	SR_DEVICE_SENSOR_PITCH_MASK		0x0000000f
#define	SR_DEVICE_SENSOR_PITCH_ERR		0x0000000f

/*-MachineName--------------------------*/
#define SR_MACHINENAME_SR2300			"SR-2300"			/* Ver4.0.0	*/
#define SR_MACHINENAME_SR5500			"SR-5500"			/* Ver4.0.0	*/
#define SR_MACHINENAME_SR3500			"SR-3500"			/* Ver4.0.0	*/
#define SR_MACHINENAME_SR6000			"SR-6000"			/* Ver4.0.0	*/
#define SR_MACHINENAME_SR6500			"SR-6500"			/* Ver4.0.0	*/
#define SR_MACHINENAME_SR1800			"SR-1800"			/* Ver4.0.0	*/


/*-Unit Name(iTarget)-------------------*/
enum{
	SR_UNIT_MAIN						= 0,		/*	Main				*/
	SR_UNIT_FRONT						,			/*	Front Sensor unit	*/
	SR_UNIT_BACK						,			/*	Back Sendor unit	*/
	SR_UNIT_BARCODE						,			/*	Barcode reader unit	*/
	SR_UNIT_PRINTER						,			/*	Printer unit		*/
	SR_UNIT_STACKER						,			/*	Stacker unit		*/
};


/*-Print Mode(iMode)--------------------*/
#define SR_PRINT_MODE_AFTER_FEED		1
#define	SR_PRINT_MODE_FEED_AND_PRINT	2


/*-Print buffer(iBufDirec)--------------*/
enum{
	SR_PRINT_BUFFER_NULL				= 0,
	SR_PRINT_BUFFER_1					,
	SR_PRINT_BUFFER_2					,
	SR_PRINT_BUFFER_3					,
};


/*-Print Buffer Size--------------------*/
#define SR_PRINT_BUFFER_LENGTH_MAX		42


/*-Print Angle(dwAngle)-----------------*/
#define SR_PRINT_ANGLE_0				1
#define	SR_PRINT_ANGLE_180				2


/*-BarcodeData--------------------------*//* Ver2.3.0	*/
#define SR_BARCODE_NUMBER_MAX			10


/*-Barcode Type(pBcType)----------------*//* Ver2.3.0	*/
#define SR_BARCODE_TYPE_UNKNOWN			'@'			/* unknown				*/
#define SR_BARCODE_TYPE_CODE39			'a'			/* CODE-39				*/
#define SR_BARCODE_TYPE_ITF				'b'			/* ITF					*/
#define SR_BARCODE_TYPE_NW7				'c'			/* NW-7					*/
#define SR_BARCODE_TYPE_JAN_EAN_UPC		'd'			/* JAN/EAN/UPC			*/
#define SR_BARCODE_TYPE_CODE128			'e'			/* CODE-128				*/
#define SR_BARCODE_TYPE_INDUSTRIAL2OF5	'f'			/* Industrial 2of5		*/
#define SR_BARCODE_TYPE_COOP2OF5		'g'			/* COOP 2of5			*/
#define SR_BARCODE_TYPE_CODE93			'h'			/* CODE-93				*/

/*-Read Barcode Type(pBcTypes)----------*//* Ver2.3.0	*/
#define SR_BARCODE_READ_INITIAL			SR_INITIAL	/* Initial				*/
#define SR_BARCODE_READ_CODE39			0x00000001	/* CODE-39				*/
#define SR_BARCODE_READ_ITF				0x00000002	/* ITF					*/
#define SR_BARCODE_READ_NW7				0x00000004	/* NW-7					*/
#define SR_BARCODE_READ_JAN_EAN_UPC		0x00000008	/* JAN/EAN/UPC			*/
#define SR_BARCODE_READ_CODE128			0x00000010	/* CODE-128				*/
#define SR_BARCODE_READ_INDUSTRIAL2OF5	0x00000020	/* Industrial 2of5		*/
#define SR_BARCODE_READ_COOP2OF5		0x00000040	/* COOP 2of5			*/
#define SR_BARCODE_READ_CODE93			0x00000080	/* CODE-93				*/

/*-Barcode CD Type(pCdType)-------------*//* Ver2.3.0	*/
enum{
	SR_BARCODE_CD_INITIAL				= SR_INITIAL,
	SR_BARCODE_CD_DISABLE				= 0,
	SR_BARCODE_CD_ENABLE				= 1,
	SR_BARCODE_CD_MODULO16				= 1,		/* Modulo 16			*/
	SR_BARCODE_CD_MODULO11				,			/* Modulo 11			*/
	SR_BARCODE_CD_MODULO10WAIT2			,			/* Modulo 10 Wait 2		*/
	SR_BARCODE_CD_MODULO10WAIT3			,			/* Modulo 10 Wait 3		*/
	SR_BARCODE_CD_7DR					,			/* 7 DR					*/
	SR_BARCODE_CD_MODULO11W				,			/* Modulo 11 Weighted	*/
	SR_BARCODE_CD_RUNES					,			/* Runes				*/
};

/*-Barcode UPC Option(dwOption)---------*//* Ver2.3.0	*/
#define SR_BARCODE_OPT_INITIAL			0xffffffff	/* initial				*/
#define SR_BARCODE_OPT_PARAM1_MASK		0x0000000f	/* Param 1				*/
#define SR_BARCODE_OPT_UPC_12DIGIT		0x00000001	/* UPC-A 12Digit		*/
#define SR_BARCODE_OPT_UPC_13DIGIT		0x00000002	/* UPC-A 13Digit		*/
#define SR_BARCODE_OPT_PARAM2_MASK		0x000000f0	/* Param 2				*/
#define SR_BARCODE_OPT_UPC_NO_CODE		0x00000010	/* UPC-E no system code	*/
#define SR_BARCODE_OPT_UPC_ADD_CODE		0x00000020	/* UPC-E add system code*/


/*-----------------------------------------------------------------------------
Form and Mark Field structures
-----------------------------------------------------------------------------*/

typedef struct tagOMR_MARK_INFO
{
	long	type;
	long	rows;
	long	columns;
}OMR_MARK_INFO, *POMR_MARK_INFO;

typedef struct tagOMR_BARCODE_AREA
{
	long	unread;
	long	read;
}OMR_BARCODE_AREA, *POMR_BARCODE_AREA;




#ifdef OMRAPI_EXPORTS
#define OMR_API __declspec(dllexport)
#else
#define OMR_API __declspec(dllimport)
#endif

#define CALLTYPE __stdcall

#ifdef __cplusplus
extern "C" {
#endif


/*-----------------------------------------------------------------------------
OMR API functions
-----------------------------------------------------------------------------*/


/*-USB Port Functions-------------------*/
OMR_API	OMR_STATUS	CALLTYPE	OMR_OpenDeviceUSB();

/*-other--------------------------------*/
OMR_API OMR_STATUS	CALLTYPE	OMR_CloseDevice(void);
OMR_API OMR_STATUS	CALLTYPE	OMR_GetLastError(void);
OMR_API const CHAR* CALLTYPE	OMR_FormatMessage(OMR_STATUS status, int iLanguageFlag);
OMR_API const CHAR*	CALLTYPE	OMR_GetST(int iPage);

/*-Commands-----------------------------*/
	/*-Settings-----------------------------*/
OMR_API BOOL		CALLTYPE	OMR_SetNumberOfColumnsToRead(int iColumns);
OMR_API int			CALLTYPE	OMR_GetNumberOfColumnsToRead(void);
OMR_API BOOL		CALLTYPE	OMR_SetReadingMethod(int iControlType, int iMultipleValue);
OMR_API BOOL		CALLTYPE	OMR_GetReadingMethod(int *iControlType, int *iMultipleValue);
OMR_API BOOL		CALLTYPE	OMR_SetBackSensorUnit(int iDirective);
OMR_API int			CALLTYPE	OMR_GetBackSensorUnit(void);
OMR_API BOOL		CALLTYPE	OMR_SetSheetFeedMode(int iMode, int iInsertTime);
OMR_API BOOL		CALLTYPE	OMR_GetSheetFeedMode(int *iMode, int *iInsertTime);
OMR_API BOOL		CALLTYPE	OMR_SetSheetThickness(int iThickness);
OMR_API int			CALLTYPE	OMR_GetSheetThickness(void);
OMR_API BOOL		CALLTYPE	OMR_SetWarningError(DWORD dwConfigData, int iSkewCol, int iSkewLevel);
OMR_API BOOL		CALLTYPE	OMR_GetWarningError(DWORD *dwConfigData, int *iSkewCol, int *iSkewLevel);
OMR_API BOOL		CALLTYPE	OMR_SetPanelConfig(int iPanelEnable);
OMR_API int			CALLTYPE	OMR_GetPanelConfig(void);
OMR_API	BOOL		CALLTYPE	OMR_SetBuzzerConfig(int iVolume, int iTone);
OMR_API BOOL		CALLTYPE	OMR_GetBuzzerConfig(int *iVolume, int *iTone);
OMR_API BOOL		CALLTYPE	OMR_SetID(CHAR *pID);
OMR_API BOOL		CALLTYPE	OMR_GetID(CHAR *pID);
OMR_API	BOOL		CALLTYPE	OMR_SetSleepTime(int iSleepTime, int iStandbyTime);
OMR_API	BOOL		CALLTYPE	OMR_GetSleepTime(int* piSleepTime, int* piStandbyTime);

	/*-movement request---------------------*/
OMR_API BOOL		CALLTYPE	OMR_Reset(void);
OMR_API BOOL		CALLTYPE	OMR_FeedSheet(void);
OMR_API BOOL		CALLTYPE	OMR_MoveHopper(int iDirection);
OMR_API BOOL		CALLTYPE	OMR_EjectSheet(int iDirection);

OMR_API BOOL		CALLTYPE	OMR_InitialSetting(void);
OMR_API OMR_STATUS	CALLTYPE	OMR_CancelError(void);

	/*-deta request-------------------------*/
OMR_API	BOOL		CALLTYPE	OMR_GetMarks(int iPage, OMR_MARK_INFO *pMarkInfo, CHAR *pMarks);
OMR_API OMR_STATUS	CALLTYPE	OMR_GetStatus(void);
OMR_API DWORD		CALLTYPE	OMR_GetSensorInfo(void);
OMR_API	DWORD		CALLTYPE	OMR_GetDeviceInfo(void);
OMR_API	BOOL		CALLTYPE	OMR_GetMachineName(CHAR* pResult);
OMR_API	BOOL		CALLTYPE	OMR_GetVersion(int iTarget, CHAR* pResult);

	/*-printer settings---------------------*/
OMR_API	BOOL		CALLTYPE	OMR_SetPrinterUnit( int iDirective );						/* Ver2.5.0	*/
OMR_API	int			CALLTYPE	OMR_GetPrinterUnit(void);									/* Ver2.5.0	*/
OMR_API	BOOL		CALLTYPE	OMR_SetPrintOrder(int iFirst, int iSecond, int iThird);
OMR_API	BOOL		CALLTYPE	OMR_GetPrintOrder(int* pFirst, int* pSecond, int* pThird);
OMR_API	BOOL		CALLTYPE	OMR_SetPrintMode(int iMode);
OMR_API	BOOL		CALLTYPE	OMR_GetPrintMode(int* piMode);
OMR_API	BOOL		CALLTYPE	OMR_SetPrintPosition(int iPosition);
OMR_API	BOOL		CALLTYPE	OMR_GetPrintPosition(int* piPosition);
OMR_API	BOOL		CALLTYPE	OMR_SetPrintAngle(DWORD dwAngle);
OMR_API	BOOL		CALLTYPE	OMR_GetPrintAngle(DWORD *dwAngle);
OMR_API	BOOL		CALLTYPE	OMR_SetPrintFontSize(int iSize);
OMR_API	BOOL		CALLTYPE	OMR_GetPrintFontSize(int *iSize);
OMR_API	BOOL		CALLTYPE	OMR_SetPrintFontPitch(int iPitch);
OMR_API	BOOL		CALLTYPE	OMR_GetPrintFontPitch(int *iPitch);
OMR_API	BOOL		CALLTYPE	OMR_SetPrintString(int iBufDirec, CHAR *pString);
OMR_API	BOOL		CALLTYPE	OMR_GetPrintString(int iBufDirec, CHAR *pString);

	/*-Barcode------------------------------*/
OMR_API BOOL		CALLTYPE	OMR_GetBarcodeInfo(int* piReadCount, int* piSettingCount);
OMR_API BOOL		CALLTYPE	OMR_GetBarcodeData(int iIndex, CHAR* pBcType, int* piDataLen, CHAR* pBarcode);

OMR_API	BOOL		CALLTYPE	OMR_SetBarcodeReaderUnit(int iDirective);
OMR_API	int			CALLTYPE	OMR_GetBarcodeReaderUnit(void);
OMR_API	BOOL		CALLTYPE	OMR_SetBarCodeArea(OMR_BARCODE_AREA* pAreaArray);
OMR_API	BOOL		CALLTYPE	OMR_GetBarCodeArea(OMR_BARCODE_AREA* pAreaArray);
OMR_API	BOOL		CALLTYPE	OMR_SetBarCodeReadType(DWORD dwReadType);
OMR_API	BOOL		CALLTYPE	OMR_GetBarCodeReadType(DWORD* pdwReadType);
OMR_API	BOOL		CALLTYPE	OMR_SetBarCodeCheckDigit(CHAR cBcType, int iCdType);
OMR_API	BOOL		CALLTYPE	OMR_GetBarCodeCheckDigit(CHAR cBcType, int* piCdType);
OMR_API	BOOL		CALLTYPE	OMR_SetBarCodeOption(CHAR cBcType, DWORD dwOption);
OMR_API	BOOL		CALLTYPE	OMR_GetBarCodeOption(CHAR cBcType, DWORD* pdwOption);


#ifdef __cplusplus
}
#endif

#endif	/*__OMR_API_H_*/
